
import { FileEditPopup } from './FileEditPopup.js';


export class FilesTab {
	
		tpl = `
		
			<table class="table">
				<thead>
					<tr>
						<th style="width: 35%;">{{_('Filename')}}</th>
						<th style="width: 35%;">{{_('Ref.')}}</th>
						<th style="width: 130px;">{{_('Size')}}</th>
						<th style="width: 150px;">{{_('Created')}}</th>
					</tr>
				</thead>
				<tbody ez-for="files" ez-item="f" id="file-listing">
					<tr [onclick]="widget.file_Click" [file]="f" class="pointer">
						<td>{{f.originalFilename}}</td>
						<td>{{f.refDescription}}</td>
						<td>
							{{ bytes2human(f.size) }}
						</td>
						<td>{{ format_datetime( new Date(f.created) ) }}</td>
					</tr>
				</tbody>
				<tr id="rec-file-table">
					<td colspan="100%">Loading...</td>
				</tr>
			</table>
		`;
		
		container = null;
		customerId = null;
		
		loading = false;
		files = [];
		
		start = 0;
		lastResponse = null;
		
		constructor() {
			this.customerId = $('#frmCustomer input[name=customerId]').val();
			
		}
		
		
		showTab() {
			this.render();
		}
		
		
		render() {
			if (!this.customerId) {
				console.error('FilesTabWidget.render, customerId not set');
				return;
			}
			
			this.addTab();
			
			
			this.renderContent();
		}
		
		
		async loadData() {
			
			if (this.loading) return;
			
			this.loading = true;
			
			
			let r = await postJson('/service/files.do', {
				customerId: this.customerId,
				start: this.start
			});
			
			let json = await r.json();
			
			
			// set next start pos
			this.start = json.start + json.pageSize;
			
			
			document.querySelector('button.nav-link#files-tab').innerText = _('Files') + ' (' + json.rowCount + ')';
			
			
			let tr_f = document.getElementById('rec-file-table');
			if (json.rowCount == 0) {
				tr_f.className = 'no-results-found';
				tr_f.querySelector('td').innerText = _('No results found');
				return;
			}
			else if (json.rowCount > this.start) {
				tr_f.querySelector('td').innerHTML = '';
				
				// Load more-text
				let anch = document.createElement('a');
				anch.className = 'load-more';
				anch.innerText = _('Load more...');
				anch.addEventListener('click', () => {
					this.loadData();
				});
				tr_f.querySelector('td').appendChild( anch );
			}
			else {
				tr_f.parentNode.removeChild( tr_f );
			}
			
			
			
			// add records
			let eztpl = document.querySelector('#file-listing').eztemplate;
			for(let i=0; i < json.files.length; i++) {
				let f = json.files[i];
				
				eztpl.createRecord( f );
			}
			
			
			// load-more
			
			
			
	//		console.log(eztpl);
			
			this.loading = false;
			
		}
		
		
		
		
		addTab() {
			let li = document.createElement('li');
			li.className = 'nav-item';
			li.setAttribute('role', 'presentation');
			
			let btn = document.createElement('button');
			btn.className = 'nav-link';
			btn.setAttribute('id', 'files-tab');
			btn.setAttribute('data-bs-toggle', 'tab');
			btn.setAttribute('data-bs-target', '#customer-files');
			btn.setAttribute('type', 'button');
			btn.setAttribute('role', 'tab');
			btn.setAttribute('aria-controls', 'files-tab');
			btn.setAttribute('aria-selected', 'false');
			btn.innerText = _('Files');
			
			li.appendChild( btn );
			
			
			insertNodeAtPos( '#customerTabs > li', 1, li );
		}
		
		
		renderContent() {
			if (this.container == null) {
				let pane = document.createElement('div');
				pane.className = 'tab-pane fade';
				pane.setAttribute('id', 'customer-files');
				pane.setAttribute('role', 'tabpanel');
				pane.setAttribute('aria-labelledby', 'files-tab');
				document.getElementById('customerTabsContent').appendChild( pane );
				
				this.container = pane;
			}
			
			
			let eztpl = new EzTemplate( this.container );
			eztpl.loadHtml( this.tpl );
			eztpl.setObject('widget', this);
			
			eztpl.setVar('loading', this.loading);
			eztpl.setVar('files', this.files);
			
			eztpl.render();
			
			this.loadData();
		}
		
		
		file_Click( evt, obj ) {
			let fid = obj.file.dbFileId;

			let fep = new FileEditPopup();
			fep.setDbFileId( fid );
			fep.show();
			fep.setCallbackClose(function() {
				this.loadFiles();
			}.bind(this));

		}
	
}


